<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'subscriptionlog' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_vbmail_subscription_log']);

	// ###################### Start modify #######################
	print_form_header('vbmail', 'subscriptionlog');
	construct_hidden_code('action', 'view');
	print_table_header($vbphrase['dbtech_vbmail_subscription_log']);
	print_input_row($vbphrase['log_entries_to_show_per_page'], 'perpage', 100);
	print_select_row($vbphrase['show_only_entries_generated_by'], 'reason', array(
		'' 									=> $vbphrase['all_log_entries'],
		'newuser' 							=> $vbphrase['dbtech_vbmail_subscriptionlog_newuser'],
		'newuser_confirmation' 				=> $vbphrase['dbtech_vbmail_subscriptionlog_newuser_confirmation'],
		'defaultsubscribed' 				=> $vbphrase['dbtech_vbmail_subscriptionlog_defaultsubscribed'],
		'defaultsubscribed_confirmation' 	=> $vbphrase['dbtech_vbmail_subscriptionlog_defaultsubscribed_confirmation'],
		'subscriptionlink'					=> $vbphrase['dbtech_vbmail_subscriptionlog_subscriptionlink'],
		'subscriptionlink_confirmation' 	=> $vbphrase['dbtech_vbmail_subscriptionlog_subscriptionlink_confirmation'],
		'banned' 							=> $vbphrase['dbtech_vbmail_subscriptionlog_banned'],
		'subscribed' 						=> $vbphrase['dbtech_vbmail_subscriptionlog_subscribed'],
		'unsubscribed' 						=> $vbphrase['dbtech_vbmail_subscriptionlog_unsubscribed'],
		'subscribed_admin' 					=> $vbphrase['dbtech_vbmail_subscriptionlog_subscribed_admin'],
		'unsubscribed_admin' 				=> $vbphrase['dbtech_vbmail_subscriptionlog_unsubscribed_admin'],
		'unsubscribed_admin_mass' 			=> $vbphrase['dbtech_vbmail_subscriptionlog_unsubscribed_admin_mass'],
		'unsubscribed_bounce' 				=> $vbphrase['dbtech_vbmail_subscriptionlog_unsubscribed_bounce'],
	), -1);
	print_time_row($vbphrase['start_date'], 'startdate', 0, 0);
	print_time_row($vbphrase['end_date'], 'enddate', 0, 0);
	print_select_row($vbphrase['order_by'], 'orderby', array(
		'date' 			=> $vbphrase['date'],
		'mailinglist' 	=> $vbphrase['dbtech_vbmail_mailinglist'],
		'user' 			=> $vbphrase['user_name'],
		'reason' 		=> $vbphrase['dbtech_vbmail_log_type']
	), 'date');
	print_submit_row($vbphrase['view'], 0);

	// ###################### Start modify #######################
	print_form_header('vbmail', 'subscriptionlog');
	construct_hidden_code('action', 'prune');
	print_table_header($vbphrase['dbtech_vbmail_prune_subscription_log']);
	print_yes_no_row($vbphrase['dbtech_vbmail_are_you_sure_prune'], 'doprune', 0);
	print_time_row($vbphrase['start_date'], 'prunestart', 0, 0);
	print_time_row($vbphrase['end_date'], 'pruneend', 0, 0);
	print_submit_row($vbphrase['dbtech_vbmail_prune'], 0);
}

// #############################################################################
if ($_REQUEST['action'] == 'view')
{
	print_cp_header($vbphrase['dbtech_vbmail_subscription_log']);

	$vbulletin->input->clean_array_gpc('r', array(
		'perpage'    => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		'reason'     => TYPE_NOHTML,
		'orderby'    => TYPE_NOHTML,
		'startdate'  => TYPE_UNIXTIME,
		'enddate'    => TYPE_UNIXTIME,
	));

	$sqlconds = array();
	$hook_query_fields = $hook_query_joins = '';

	if ($vbulletin->GPC['perpage'] < 1)
	{
		$vbulletin->GPC['perpage'] = 15;
	}

	if ($vbulletin->GPC['reason'])
	{
		$sqlconds[] = "subscriptionlog.reason = " . $db->sql_prepare($vbulletin->GPC['reason']);
	}

	if ($vbulletin->GPC['startdate'])
	{
		$sqlconds[] = "subscriptionlog.dateline >= " . $vbulletin->GPC['startdate'];
	}

	if ($vbulletin->GPC['enddate'])
	{
		$sqlconds[] = "subscriptionlog.dateline <= " . $vbulletin->GPC['enddate'];
	}

	//($hook = vBulletinHook::fetch_hook('admin_modlogviewer_query')) ? eval($hook) : false;

	$counter = $db->query_first_slave("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "dbtech_vbmail_subscriptionlog AS subscriptionlog
		" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
	");
	$totalpages = ceil($counter['total'] / $vbulletin->GPC['perpage']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	switch($vbulletin->GPC['orderby'])
	{
		case 'reason':
			$order = 'subscriptionlog.reason ASC, dateline DESC';
			break;

		case 'user':
			$order = 'user.username ASC, dateline DESC';
			break;

		case 'mailinglist':
			$order = 'maiilinglist.title ASC, dateline DESC';
			break;

		case 'date':
		default:
			$order = 'dateline DESC';
	}

	$logs = $db->query_read_slave("
		SELECT subscriptionlog.*, user.username
			$hook_query_fields
		FROM " . TABLE_PREFIX . "dbtech_vbmail_subscriptionlog AS subscriptionlog
		LEFT JOIN " . TABLE_PREFIX . "dbtech_vbmail_mailinglist AS mailinglist ON(mailinglist.mailinglistid = subscriptionlog.mailinglistid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = subscriptionlog.userid)
		$hook_join_fields
		" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
		ORDER BY $order
		LIMIT $startat, " . $vbulletin->GPC['perpage'] . "
	");

	if ($db->num_rows($logs))
	{
		if ($vbulletin->GPC['pagenumber'] != 1)
		{
			$prv = $vbulletin->GPC['pagenumber'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=subscriptionlog&action=view&reason=" . $vbulletin->GPC['reason'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=subscriptionlog&action=view&reason=" . $vbulletin->GPC['reason'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$prv'\">";
		}

		if ($vbulletin->GPC['pagenumber'] != $totalpages)
		{
			$nxt = $vbulletin->GPC['pagenumber'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=subscriptionlog&action=view&reason=" . $vbulletin->GPC['reason'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=subscriptionlog&action=view&reason=" . $vbulletin->GPC['reason'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$totalpages'\">";
		}

		$headings = array();
		$headings[] = $vbphrase['id'];
		$headings[] = "<a href=\"vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=subscriptionlog&action=view&reason=" . $vbulletin->GPC['reason'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=user&page=" . $vbulletin->GPC['pagenumber'] . "\">" . str_replace(' ', '&nbsp;', $vbphrase['user_name']) . "</a>";
		$headings[] = "<a href=\"vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=subscriptionlog&action=view&reason=" . $vbulletin->GPC['reason'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=mailinglist&page=" . $vbulletin->GPC['pagenumber'] . "\">" . $vbphrase['dbtech_vbmail_mailinglist'] . "</a>";
		$headings[] = "<a href=\"vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=subscriptionlog&action=view&reason=" . $vbulletin->GPC['reason'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=date&page=" . $vbulletin->GPC['pagenumber'] . "\">" . $vbphrase['date'] . "</a>";
		$headings[] = $vbphrase['status'];
		$headings[] = "<a href=\"vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=subscriptionlog&action=view&reason=" . $vbulletin->GPC['reason'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=reason&page=" . $vbulletin->GPC['pagenumber'] . "\">" . $vbphrase['dbtech_vbmail_log_type'] . "</a>";

		?>
		<script type="text/javascript">
		function js_usergroup_jump(userinfo)
		{
			var value = eval("document.cpform.u" + userinfo + ".options[document.cpform.u" + userinfo + ".selectedIndex].value");
			if (value != "")
			{
				window.location = "vbmail.php?<?php echo $vbulletin->session->vars['sessionurl_js']; ?>do=subscriptionlog&action=" + value + "&subscriptionlogid=" + userinfo;
			}
		}
		</script>
		<?php

		print_form_header('', '');
		print_description_row(construct_link_code($vbphrase['restart'], "vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=subscriptionlog"), false, count($headings), 'thead', 'right');
		print_table_header(construct_phrase($vbphrase['dbtech_vbmail_subscription_log_page_x_y_there_are_z_total_log_entries'], vb_number_format($vbulletin->GPC['pagenumber']), vb_number_format($totalpages), vb_number_format($counter['total'])), count($headings));
		print_cells_row($headings, 1);

		while ($log = $db->fetch_array($logs))
		{
			$cell = array();
			$cell[] = $log['subscriptionlogid'];
			$cell[] = ($log['username'] ? "<a href=\"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&u=$log[userid]\"><b>$log[username]</b></a>" : $vbphrase['n_a']);
			$cell[] = (isset(VBMAIL::$cache['mailinglist'][$log['mailinglistid']]) ? VBMAIL::$cache['mailinglist'][$log['mailinglistid']]['title'] : $vbphrase['n_a']);
			$cell[] = '<span class="smallfont">' . vbdate($vbulletin->options['logdateformat'], $log['dateline']) . '</span>';
			$cell[] = $vbphrase['dbtech_vbmail_' . (!$log['subscribed'] ? 'un' : '') . 'subscribed'];
			$cell[] = (isset($vbphrase['dbtech_vbmail_subscriptionlog_' . $log['reason']]) ? $vbphrase['dbtech_vbmail_subscriptionlog_' . $log['reason']] : 'dbtech_vbmail_subscriptionlog_' . $log['reason']);
			print_cells_row($cell, false, false, 0, 'top', false, true);
		}

		print_table_footer(count($headings), "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		print_stop_message('no_results_matched_your_query');
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'prune')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'doprune'    => TYPE_BOOL,
		'prunestart'  => TYPE_UNIXTIME,
		'pruneend'    => TYPE_UNIXTIME,
	));

	if (!$vbulletin->GPC['doprune'])
	{
		// Nothing to do
		print_stop_message('nothing_to_do');
	}

	$sqlconds = array();

	if ($vbulletin->GPC['prunestart'])
	{
		$sqlconds[] = "dateline >= " . $vbulletin->GPC['prunestart'];
	}

	if ($vbulletin->GPC['pruneend'])
	{
		$sqlconds[] = "dateline <= " . $vbulletin->GPC['pruneend'];
	}

	//($hook = vBulletinHook::fetch_hook('admin_modlogviewer_query')) ? eval($hook) : false;

	$counter = $db->query_write("
		DELETE FROM " . TABLE_PREFIX . "dbtech_vbmail_subscriptionlog
		" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
	");

	define('CP_REDIRECT', 'vbmail.php?do=subscriptionlog');
	print_stop_message('dbtech_vbmail_x_y', $vbphrase['dbtech_vbmail_subscriptionlog'], $vbphrase['dbtech_vbmail_deleted']);
}

print_cp_footer();